<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tłumacz Imion Polskich</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        html, body {
            height: 100%;
        }
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .main-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.25rem rgba(102, 126, 234, 0.25);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 12px 40px;
            font-size: 1.1rem;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd6 0%, #6a4190 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        .results-table {
            max-height: 500px;
            overflow-y: auto;
        }
        .speak-btn {
            cursor: pointer;
            color: #667eea;
            transition: all 0.2s;
        }
        .speak-btn:hover {
            color: #764ba2;
            transform: scale(1.2);
        }
        .flag-emoji {
            font-size: 1.5rem;
        }
        .table-hover tbody tr:hover {
            background-color: rgba(102, 126, 234, 0.1);
        }
        .speaking {
            animation: pulse 0.5s infinite;
        }
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6">
                    <div class="card p-4 p-md-5">
                        <div class="card-body text-center">
                            <h2 class="mb-4">
                                <i class="bi bi-translate text-primary"></i>
                                Tłumacz Imion
                            </h2>
                            <p class="text-muted mb-4">Wpisz polskie imię, aby zobaczyć jego odpowiedniki w innych językach</p>

                            <form method="POST" action="" id="nameForm">
                                <div class="mb-4">
                                    <label for="firstName" class="form-label fw-bold">Podaj imię po polsku:</label>
                                    <input type="text"
                                           class="form-control form-control-lg text-center"
                                           id="firstName"
                                           name="firstName"
                                           placeholder="np. Jan, Maria, Piotr..."
                                           value="<?php echo isset($_POST['firstName']) ? htmlspecialchars($_POST['firstName']) : ''; ?>"
                                           required
                                           autocomplete="off">
                                </div>
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-search me-2"></i>Szukaj
                                </button>
                            </form>

                            <?php
                            if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['firstName'])) {
                                $inputName = trim($_POST['firstName']);
                                $inputName = mb_convert_case($inputName, MB_CASE_TITLE, "UTF-8");

                                $nameDatabase = getNameDatabase();
                                $results = findNameEquivalents($inputName, $nameDatabase);

                                if (!empty($results)) {
                                    echo '<div class="mt-5">';
                                    echo '<h4 class="mb-3"><i class="bi bi-globe2 text-primary me-2"></i>Odpowiedniki imienia "' . htmlspecialchars($inputName) . '"</h4>';
                                    echo '<div class="results-table">';
                                    echo '<table class="table table-hover">';
                                    echo '<thead class="table-light sticky-top"><tr>';
                                    echo '<th>Kraj / Język</th>';
                                    echo '<th>Imię</th>';
                                    echo '<th class="text-center">Wymowa</th>';
                                    echo '</tr></thead>';
                                    echo '<tbody>';

                                    // Sort by language name alphabetically
                                    usort($results, function($a, $b) {
                                        return strcmp($a['language'], $b['language']);
                                    });

                                    foreach ($results as $result) {
                                        $langCode = $result['langCode'];
                                        $flag = $result['flag'];
                                        $language = htmlspecialchars($result['language']);
                                        $name = htmlspecialchars($result['name']);

                                        echo '<tr>';
                                        echo '<td><span class="flag-emoji me-2">' . $flag . '</span>' . $language . '</td>';
                                        echo '<td class="fw-bold">' . $name . '</td>';
                                        echo '<td class="text-center">';
                                        echo '<i class="bi bi-volume-up-fill speak-btn fs-5" ';
                                        echo 'onclick="speakName(\'' . addslashes($name) . '\', \'' . $langCode . '\')" ';
                                        echo 'title="Posłuchaj wymowy"></i>';
                                        echo '</td>';
                                        echo '</tr>';
                                    }

                                    echo '</tbody></table>';
                                    echo '</div>';
                                    echo '<p class="text-muted small mt-3"><i class="bi bi-info-circle me-1"></i>Znaleziono ' . count($results) . ' odpowiedników</p>';
                                    echo '</div>';
                                } else {
                                    echo '<div class="alert alert-warning mt-4">';
                                    echo '<i class="bi bi-exclamation-triangle me-2"></i>';
                                    echo 'Nie znaleziono odpowiedników dla imienia "' . htmlspecialchars($inputName) . '". ';
                                    echo 'Spróbuj wpisać popularne polskie imię jak: Jan, Maria, Piotr, Anna, Katarzyna, Michał.';
                                    echo '</div>';
                                }
                            }

                            function getNameDatabase() {
                                return [
                                    'Jan' => [
                                        ['name' => 'Jan', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'John', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Jean', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Johann', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Giovanni', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Juan', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'João', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Ivan', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Іван', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Иван', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Ιωάννης', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Jón', 'language' => 'Islandzki', 'langCode' => 'is-IS', 'flag' => '🇮🇸'],
                                        ['name' => 'Jaan', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Jānis', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Jonas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Honza', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Ján', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'János', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Ion', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Jovan', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Ivan', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Janez', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Seán', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'Iain', 'language' => 'Szkocki', 'langCode' => 'gd-GB', 'flag' => '🏴󠁧󠁢󠁳󠁣󠁴󠁿'],
                                        ['name' => 'Evan', 'language' => 'Walijski', 'langCode' => 'cy-GB', 'flag' => '🏴󠁧󠁢󠁷󠁬󠁳󠁿'],
                                        ['name' => 'Yahya', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'יוחנן', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                        ['name' => 'یحیی', 'language' => 'Perski', 'langCode' => 'fa-IR', 'flag' => '🇮🇷'],
                                        ['name' => 'Yohanes', 'language' => 'Indonezyjski', 'langCode' => 'id-ID', 'flag' => '🇮🇩'],
                                        ['name' => 'Yohannes', 'language' => 'Amharski', 'langCode' => 'am-ET', 'flag' => '🇪🇹'],
                                        ['name' => 'Gjon', 'language' => 'Albański', 'langCode' => 'sq-AL', 'flag' => '🇦🇱'],
                                        ['name' => 'Jan', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Jan', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Jan', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Jan', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Juhani', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                    ],
                                    'Maria' => [
                                        ['name' => 'Maria', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Mary', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Marie', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Maria', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Maria', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'María', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Maria', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Мария', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Марія', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Μαρία', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Mária', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Marie', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Mária', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Marija', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Marija', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Maarja', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Marija', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Marija', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Marija', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Maria', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Мария', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Maria', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Maria', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Maria', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Maria', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Maria', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Máire', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'Maryam', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'מרים', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                        ['name' => 'مریم', 'language' => 'Perski', 'langCode' => 'fa-IR', 'flag' => '🇮🇷'],
                                        ['name' => 'Miriam', 'language' => 'Amharski', 'langCode' => 'am-ET', 'flag' => '🇪🇹'],
                                    ],
                                    'Piotr' => [
                                        ['name' => 'Piotr', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Peter', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Pierre', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Peter', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Pietro', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Pedro', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Pedro', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Пётр', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Петро', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Πέτρος', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Péter', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Petr', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Peter', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Petras', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Pēteris', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Peeter', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Peter', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Petar', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Петар', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Petre', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Петър', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Peter', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Peter', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Peter', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Pietari', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Pieter', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Peadar', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'Pétur', 'language' => 'Islandzki', 'langCode' => 'is-IS', 'flag' => '🇮🇸'],
                                        ['name' => 'Pjetër', 'language' => 'Albański', 'langCode' => 'sq-AL', 'flag' => '🇦🇱'],
                                        ['name' => 'بطرس', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'פטר', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Anna' => [
                                        ['name' => 'Anna', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Anne', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Anne', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Anna', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Anna', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Ana', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Ana', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Анна', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Ганна', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Άννα', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Anna', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Anna', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Anna', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Ona', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Anna', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Anna', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Ana', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Ana', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Ана', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Ana', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Анна', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Anna', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Anna', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Anna', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Anna', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Anna', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Áine', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'حنة', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'חנה', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Katarzyna' => [
                                        ['name' => 'Katarzyna', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Catherine', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Catherine', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Katharina', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Caterina', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Catalina', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Catarina', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Екатерина', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Катерина', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Αικατερίνη', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Katalin', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Kateřina', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Katarína', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Kotryna', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Katrīna', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Kadri', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Katarina', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Katarina', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Катарина', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Ecaterina', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Екатерина', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Katarina', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Katrine', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Katrine', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Katariina', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Catharina', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Caitríona', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                    ],
                                    'Michał' => [
                                        ['name' => 'Michał', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Michael', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Michel', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Michael', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Michele', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Miguel', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Miguel', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Михаил', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Михайло', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Μιχαήλ', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Mihály', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Michal', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Michal', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Mykolas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Miķelis', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Mihkel', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Mihael', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Mihael', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Михаило', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Mihai', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Михаил', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Mikael', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Mikael', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Mikael', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Mikael', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Michaël', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Mícheál', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'ميخائيل', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'מיכאל', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Paweł' => [
                                        ['name' => 'Paweł', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Paul', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Paul', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Paul', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Paolo', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Pablo', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Paulo', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Павел', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Павло', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Παύλος', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Pál', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Pavel', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Pavol', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Paulius', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Pāvils', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Paul', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Pavel', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Pavao', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Павле', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Pavel', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Павел', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Pål', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Pål', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Poul', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Paavali', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇱'],
                                        ['name' => 'Paul', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Pól', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'بولس', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                    ],
                                    'Krzysztof' => [
                                        ['name' => 'Krzysztof', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Christopher', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Christophe', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Christoph', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Cristoforo', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Cristóbal', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Cristóvão', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Христофор', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Христофор', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Χριστόφορος', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Kristóf', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Kryštof', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Krištof', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Kristupas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Kristaps', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Kristjan', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Krištof', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Kristofor', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Кристифор', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Cristofor', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Христофор', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Kristoffer', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Kristoffer', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Kristoffer', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Risto', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Christoffel', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                    ],
                                    'Andrzej' => [
                                        ['name' => 'Andrzej', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Andrew', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'André', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Andreas', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Andrea', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Andrés', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'André', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Андрей', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Андрій', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Ανδρέας', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'András', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Ondřej', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Ondrej', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Andrius', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Andrejs', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Andres', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Andrej', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Andrija', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Андрија', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Andrei', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Андрей', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Anders', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Anders', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Anders', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Antero', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Andreas', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Aindriú', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                    ],
                                    'Tomasz' => [
                                        ['name' => 'Tomasz', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Thomas', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Thomas', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Thomas', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Tommaso', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Tomás', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Tomás', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Фома', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Тома', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Θωμάς', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Tamás', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Tomáš', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Tomáš', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Tomas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Toms', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Toomas', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Tomaž', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Toma', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Тома', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Toma', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Тома', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Tomas', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Thomas', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Thomas', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Tuomas', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Thomas', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                    ],
                                    'Magdalena' => [
                                        ['name' => 'Magdalena', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Magdalene', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Madeleine', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Magdalena', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Maddalena', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Magdalena', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Madalena', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Магдалина', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Магдалина', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Μαγδαληνή', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Magdolna', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Magdaléna', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Magdaléna', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Magdalena', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Magdalena', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Magdalene', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Matleena', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Magdalena', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                    ],
                                    'Ewa' => [
                                        ['name' => 'Ewa', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Eve', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Ève', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Eva', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Eva', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Eva', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Eva', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Ева', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Єва', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Εύα', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Éva', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Eva', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Eva', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Ieva', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Ieva', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Eeva', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Eva', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Eva', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Ева', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Eva', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Ева', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Eva', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Eva', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Eva', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Eeva', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Eva', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Aoife', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'حواء', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'חוה', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Zofia' => [
                                        ['name' => 'Zofia', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Sophia', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Sophie', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Sofia', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Sofia', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Sofía', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Sofia', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'София', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Софія', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Σοφία', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Zsófia', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Žofie', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Žofia', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Sofija', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Sofija', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Sofia', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Zofija', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Sofija', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Софија', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Sofia', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'София', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Sofia', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Sofia', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Sofia', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Sofia', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Sofia', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                    ],
                                    'Adam' => [
                                        ['name' => 'Adam', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Adam', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Adam', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Adam', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Adamo', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Adán', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Adão', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Адам', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Адам', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Αδάμ', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Ádám', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Adam', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Adam', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Adomas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Ādams', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Aadam', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Adam', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Adam', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Адам', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Adam', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Адам', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Adam', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Adam', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Adam', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Aatami', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Adam', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Ádhamh', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'آدم', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'אדם', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Jakub' => [
                                        ['name' => 'Jakub', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Jacob', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Jacques', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Jakob', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Giacomo', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Jacobo', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Jacó', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Яков', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Яків', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Ιάκωβος', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Jakab', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Jakub', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Jakub', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Jokūbas', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Jēkabs', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Jaakob', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Jakob', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Jakov', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Јаков', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Iacob', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Яков', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Jakob', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Jakob', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Jakob', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Jaakko', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Jacob', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Séamus', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'يعقوب', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                        ['name' => 'יעקב', 'language' => 'Hebrajski', 'langCode' => 'he-IL', 'flag' => '🇮🇱'],
                                    ],
                                    'Aleksandra' => [
                                        ['name' => 'Aleksandra', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Alexandra', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Alexandra', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Alexandra', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Alessandra', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Alejandra', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Alexandra', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Александра', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Олександра', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Αλεξάνδρα', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Alexandra', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Alexandra', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Alexandra', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Aleksandra', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Aleksandra', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Aleksandra', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Aleksandra', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Aleksandra', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Александра', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Alexandra', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Александра', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Alexandra', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Alexandra', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Alexandra', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Aleksandra', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Alexandra', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                    ],
                                    'Aleksander' => [
                                        ['name' => 'Aleksander', 'language' => 'Polski', 'langCode' => 'pl-PL', 'flag' => '🇵🇱'],
                                        ['name' => 'Alexander', 'language' => 'Angielski', 'langCode' => 'en-US', 'flag' => '🇺🇸'],
                                        ['name' => 'Alexandre', 'language' => 'Francuski', 'langCode' => 'fr-FR', 'flag' => '🇫🇷'],
                                        ['name' => 'Alexander', 'language' => 'Niemiecki', 'langCode' => 'de-DE', 'flag' => '🇩🇪'],
                                        ['name' => 'Alessandro', 'language' => 'Włoski', 'langCode' => 'it-IT', 'flag' => '🇮🇹'],
                                        ['name' => 'Alejandro', 'language' => 'Hiszpański', 'langCode' => 'es-ES', 'flag' => '🇪🇸'],
                                        ['name' => 'Alexandre', 'language' => 'Portugalski', 'langCode' => 'pt-PT', 'flag' => '🇵🇹'],
                                        ['name' => 'Александр', 'language' => 'Rosyjski', 'langCode' => 'ru-RU', 'flag' => '🇷🇺'],
                                        ['name' => 'Олександр', 'language' => 'Ukraiński', 'langCode' => 'uk-UA', 'flag' => '🇺🇦'],
                                        ['name' => 'Αλέξανδρος', 'language' => 'Grecki', 'langCode' => 'el-GR', 'flag' => '🇬🇷'],
                                        ['name' => 'Sándor', 'language' => 'Węgierski', 'langCode' => 'hu-HU', 'flag' => '🇭🇺'],
                                        ['name' => 'Alexandr', 'language' => 'Czeski', 'langCode' => 'cs-CZ', 'flag' => '🇨🇿'],
                                        ['name' => 'Alexander', 'language' => 'Słowacki', 'langCode' => 'sk-SK', 'flag' => '🇸🇰'],
                                        ['name' => 'Aleksandras', 'language' => 'Litewski', 'langCode' => 'lt-LT', 'flag' => '🇱🇹'],
                                        ['name' => 'Aleksandrs', 'language' => 'Łotewski', 'langCode' => 'lv-LV', 'flag' => '🇱🇻'],
                                        ['name' => 'Aleksander', 'language' => 'Estoński', 'langCode' => 'et-EE', 'flag' => '🇪🇪'],
                                        ['name' => 'Aleksander', 'language' => 'Słoweński', 'langCode' => 'sl-SI', 'flag' => '🇸🇮'],
                                        ['name' => 'Aleksandar', 'language' => 'Chorwacki', 'langCode' => 'hr-HR', 'flag' => '🇭🇷'],
                                        ['name' => 'Александар', 'language' => 'Serbski', 'langCode' => 'sr-RS', 'flag' => '🇷🇸'],
                                        ['name' => 'Alexandru', 'language' => 'Rumuński', 'langCode' => 'ro-RO', 'flag' => '🇷🇴'],
                                        ['name' => 'Александър', 'language' => 'Bułgarski', 'langCode' => 'bg-BG', 'flag' => '🇧🇬'],
                                        ['name' => 'Alexander', 'language' => 'Szwedzki', 'langCode' => 'sv-SE', 'flag' => '🇸🇪'],
                                        ['name' => 'Aleksander', 'language' => 'Norweski', 'langCode' => 'no-NO', 'flag' => '🇳🇴'],
                                        ['name' => 'Alexander', 'language' => 'Duński', 'langCode' => 'da-DK', 'flag' => '🇩🇰'],
                                        ['name' => 'Aleksanteri', 'language' => 'Fiński', 'langCode' => 'fi-FI', 'flag' => '🇫🇮'],
                                        ['name' => 'Alexander', 'language' => 'Holenderski', 'langCode' => 'nl-NL', 'flag' => '🇳🇱'],
                                        ['name' => 'Alastar', 'language' => 'Irlandzki', 'langCode' => 'ga-IE', 'flag' => '🇮🇪'],
                                        ['name' => 'إسكندر', 'language' => 'Arabski', 'langCode' => 'ar-SA', 'flag' => '🇸🇦'],
                                    ],
                                ];
                            }

                            function findNameEquivalents($inputName, $nameDatabase) {
                                // Direct match
                                if (isset($nameDatabase[$inputName])) {
                                    return $nameDatabase[$inputName];
                                }

                                // Case-insensitive search
                                foreach ($nameDatabase as $baseName => $equivalents) {
                                    if (mb_strtolower($baseName, 'UTF-8') === mb_strtolower($inputName, 'UTF-8')) {
                                        return $equivalents;
                                    }

                                    // Search within equivalents
                                    foreach ($equivalents as $equiv) {
                                        if (mb_strtolower($equiv['name'], 'UTF-8') === mb_strtolower($inputName, 'UTF-8')) {
                                            return $equivalents;
                                        }
                                    }
                                }

                                return [];
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        function speakName(name, langCode) {
            if ('speechSynthesis' in window) {
                // Cancel any ongoing speech
                window.speechSynthesis.cancel();

                const utterance = new SpeechSynthesisUtterance(name);
                utterance.lang = langCode;
                utterance.rate = 0.9;

                // Find the clicked icon and add animation
                const icons = document.querySelectorAll('.speak-btn');
                icons.forEach(icon => icon.classList.remove('speaking'));
                event.target.classList.add('speaking');

                utterance.onend = function() {
                    event.target.classList.remove('speaking');
                };

                utterance.onerror = function() {
                    event.target.classList.remove('speaking');
                    alert('Przepraszamy, wymowa dla tego języka nie jest dostępna w Twojej przeglądarce.');
                };

                window.speechSynthesis.speak(utterance);
            } else {
                alert('Twoja przeglądarka nie obsługuje funkcji wymowy.');
            }
        }

        $(document).ready(function() {
            $('#firstName').focus();
        });
    </script>
</body>
</html>
